//	TorusGamesRootController.h
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import "GeometryGamesGraphicsViewController.h"
#import "TorusGamesKeyboardView.h"
#import "TorusGamesMatteView.h"
#import "TorusGamesGameChoiceController.h"
#import "TorusGamesOptionsChoiceController.h"
#import "TorusGamesLanguageChoiceController.h"
#import "TorusGamesHelpChoiceController.h"


@interface TorusGamesRootController : GeometryGamesGraphicsViewController
	<TorusGamesKeyboardViewDelegate, TorusGamesMatteViewDelegate,
	TorusGamesGameChoiceDelegate, TorusGamesOptionsChoiceDelegate,
	TorusGamesLanguageChoiceDelegate, TorusGamesHelpChoiceDelegate>

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;
- (void)dealloc;
- (BOOL)prefersStatusBarHidden;
- (void)viewDidLoad;
- (void)viewWillLayoutSubviews;

- (void)viewWillTransitionToSize:(CGSize)size withTransitionCoordinator:(id<UIViewControllerTransitionCoordinator>)coordinator;
- (void)viewSafeAreaInsetsDidChange;
- (void)traitCollectionDidChange:(UITraitCollection *)previousTraitCollection;

- (void)setMessageText:(NSString *)aMessage forGame:(GameType)aGame;
- (void)setMessageColor:(UIColor *)aColor;

- (void)simulateChangeGameButtonTap;

//	TorusGamesGameChoiceDelegate
- (void)userDidChooseGame:(GameType)aNewGame;
- (void)userDidCancelGameChoice;
- (void)changeGame:(GameType)aNewGame;

//	TorusGamesOptionsChoiceDelegate
- (void)userDidChooseOptionHumanVsComputer:(bool)aHumanVsComputer;
- (void)userDidChooseOptionTopology:(TopologyType)aTopology;
- (void)userDidChooseOptionDifficultyLevel:(unsigned int)aDifficultyLevel;
- (void)userDidChooseOptionViewType:(ViewType)aViewType;
- (void)userDidChooseOptionSoundEffects:(bool)aSoundEffects;
- (void)userDidCancelOptionsChoice;

//	TorusGamesLanguageChoiceDelegate
- (void)userDidChooseLanguage:(const Char16 [3])aTwoLetterLanguageCode;
- (void)userDidCancelLanguageChoice;

//	TorusGamesHelpChoiceDelegate
- (void)dismissHelp;
- (bool)practiceBoardIsSelected;
- (void)selectPracticeBoard;
- (void)requestGame:(GameType)aNewGame;

//	TorusGamesKeyboardViewDelegate
- (void)userTappedKey:(unichar)aCharacter;

//	TorusGamesMatteViewDelegate
- (void)matteViewDidSetLayoutOrientation:(MatteViewLayoutOrientation)aMatteViewLayoutOrientation;

#ifdef SCIENCE_CENTER_VERSION
//- (void)userIsStillPlaying;
#endif

@end
